//
//  GSReadFromCharstring.h
//  GlyphsCore
//
//  Created by Georg Seifert on 03.12.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

NSString *copyReadString(const char *line, NSInteger length) __attribute((ns_returns_retained));

NSString *copyReadQuotedString(const char *line, NSInteger maxLength);

NSString *copyReadTextLine(const char *line, size_t length) __attribute((ns_returns_retained));

NSString *copyReadText(const char *line, size_t length, FILE *file, char endChar) __attribute((ns_returns_retained));

void skipWhite(const char *line, NSUInteger *pos, NSUInteger length);

NSInteger readInt(const char *line, NSUInteger *pos);

NSInteger readHex(const char *line, NSUInteger *pos);

CGFloat String2Float(NSString *string);

CGFloat readFloat(const char *line, NSUInteger *pos);

BOOL readFloatList(const char *line, NSUInteger *pos, CGFloat *values, NSInteger *count);

BOOL readIntList(const char *line, NSUInteger *pos, NSInteger *values, NSInteger *count);

NSPoint readPoint(const char *line, NSUInteger *pos);

NSColor *readColor(const char *line, NSUInteger *pos);

NSString *copyReadKey(const char *line, NSUInteger *pos) __attribute((ns_returns_retained));

NSString *copyReadValue(const char *line, NSUInteger *pos, NSUInteger MaxLength) __attribute((ns_returns_retained));

NSDate *readDate(const char *line, NSUInteger length);

NSDate *dateFromString(const char *line, NSUInteger *pos);

NSAffineTransformStruct readTransformation(const char *line, NSUInteger *pos);
